function _typeof(obj){return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(obj){return typeof obj}:function(obj){return obj&&"function"==typeof Symbol&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj},_typeof(obj)
/**
 * Controls the search page of the message drawer.
 *
 * @module     core_message/message_drawer_view_search
 * @copyright  2018 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */}define("core_message/message_drawer_view_search",["jquery","core/custom_interaction_events","core/notification","core/pubsub","core/str","core/templates","core_message/message_repository","core_message/message_drawer_events"],(function($,CustomEvents,Notification,PubSub,Str,Templates,Repository,Events){var SELECTORS_BLOCK_ICON_CONTAINER='[data-region="block-icon-container"]',SELECTORS_CANCEL_SEARCH_BUTTON='[data-action="cancel-search"]',SELECTORS_CONTACTS_CONTAINER='[data-region="contacts-container"]',SELECTORS_CONTACTS_LIST='[data-region="contacts-container"] [data-region="list"]',SELECTORS_EMPTY_MESSAGE_CONTAINER='[data-region="empty-message-container"]',SELECTORS_LIST='[data-region="list"]',SELECTORS_LOADING_ICON_CONTAINER='[data-region="loading-icon-container"]',SELECTORS_LOADING_PLACEHOLDER='[data-region="loading-placeholder"]',SELECTORS_MESSAGES_LIST='[data-region="messages-container"] [data-region="list"]',SELECTORS_MESSAGES_CONTAINER='[data-region="messages-container"]',SELECTORS_NON_CONTACTS_CONTAINER='[data-region="non-contacts-container"]',SELECTORS_NON_CONTACTS_LIST='[data-region="non-contacts-container"] [data-region="list"]',SELECTORS_SEARCH_ICON_CONTAINER='[data-region="search-icon-container"]',SELECTORS_SEARCH_ACTION='[data-action="search"]',SELECTORS_SEARCH_INPUT='[data-region="search-input"]',SELECTORS_SEARCH_RESULTS_CONTAINER='[data-region="search-results-container"]',SELECTORS_LOAD_MORE_USERS='[data-action="load-more-users"]',SELECTORS_LOAD_MORE_MESSAGES='[data-action="load-more-messages"]',SELECTORS_BUTTON_TEXT='[data-region="button-text"]',SELECTORS_NO_RESULTS_CONTAINTER='[data-region="no-results-container"]',SELECTORS_ALL_CONTACTS_CONTAINER='[data-region="all-contacts-container"]',TEMPLATES_CONTACTS_LIST="core_message/message_drawer_contacts_list",TEMPLATES_NON_CONTACTS_LIST="core_message/message_drawer_non_contacts_list",TEMPLATES_MESSAGES_LIST="core_message/message_drawer_messages_list",getLoggedInUserId=function(body){return body.attr("data-user-id")},getEmptyMessageContainer=function(body){return body.find(SELECTORS_EMPTY_MESSAGE_CONTAINER)},getLoadingIconContainer=function(header){return header.find(SELECTORS_LOADING_ICON_CONTAINER)},getLoadingPlaceholder=function(body){return body.find(SELECTORS_LOADING_PLACEHOLDER)},getSearchIconContainer=function(header){return header.find(SELECTORS_SEARCH_ICON_CONTAINER)},getSearchInput=function(header){return header.find(SELECTORS_SEARCH_INPUT)},getSearchResultsContainer=function(body){return body.find(SELECTORS_SEARCH_RESULTS_CONTAINER)},getContactsContainer=function(body){return body.find(SELECTORS_CONTACTS_CONTAINER)},getNonContactsContainer=function(body){return body.find(SELECTORS_NON_CONTACTS_CONTAINER)},hideEmptyMessage=function(body){getEmptyMessageContainer(body).addClass("hidden")},hideLoadingIcon=function(header){getLoadingIconContainer(header).addClass("hidden")},hideLoadingPlaceholder=function(body){getLoadingPlaceholder(body).addClass("hidden")},showSearchIcon=function(header){getSearchIconContainer(header).removeClass("hidden")},hideSearchResults=function(body){getSearchResultsContainer(body).addClass("hidden")},clearAllSearchResults=function(body){body.find(SELECTORS_CONTACTS_LIST).empty(),body.find(SELECTORS_NON_CONTACTS_LIST).empty(),body.find(SELECTORS_MESSAGES_LIST).empty(),function(body){var container=getSearchResultsContainer(body);container.find(SELECTORS_ALL_CONTACTS_CONTAINER).removeClass("hidden"),container.find(SELECTORS_MESSAGES_CONTAINER).removeClass("hidden"),container.find(SELECTORS_NO_RESULTS_CONTAINTER).addClass("hidden")}(body),function(body){getSearchResultsContainer(body).find(SELECTORS_ALL_CONTACTS_CONTAINER).removeClass("hidden")}(body),function(body){getSearchResultsContainer(body).find(SELECTORS_CONTACTS_CONTAINER).removeClass("hidden")}(body),function(body){getSearchResultsContainer(body).find(SELECTORS_NON_CONTACTS_CONTAINER).removeClass("hidden")}(body),function(body){getSearchResultsContainer(body).find(SELECTORS_MESSAGES_CONTAINER).removeClass("hidden")}(body),showLoadMoreUsersButton(body),showLoadMoreMessagesButton(body)},startLoading=function(header,body){!function(header){getSearchIconContainer(header).addClass("hidden")}(header),hideEmptyMessage(body),hideSearchResults(body),function(header){getLoadingIconContainer(header).removeClass("hidden")}(header),function(body){getLoadingPlaceholder(body).removeClass("hidden")}(body),function(header){getSearchInput(header).prop("disabled",!0)}(header)},stopLoading=function(header,body){showSearchIcon(header),hideEmptyMessage(body),function(body){getSearchResultsContainer(body).removeClass("hidden")}(body),hideLoadingIcon(header),hideLoadingPlaceholder(body),function(header){getSearchInput(header).prop("disabled",!1)}(header)},hideUsersLoadingIcon=function(root){var button=root.find(SELECTORS_LOAD_MORE_USERS);button.prop("disabled",!1),button.find(SELECTORS_BUTTON_TEXT).removeClass("hidden"),button.find(SELECTORS_LOADING_ICON_CONTAINER).addClass("hidden")},showLoadMoreUsersButton=function(root){root.find(SELECTORS_LOAD_MORE_USERS).removeClass("hidden")},hideMessagesLoadingIcon=function(root){var button=root.find(SELECTORS_LOAD_MORE_MESSAGES);button.prop("disabled",!1),button.find(SELECTORS_BUTTON_TEXT).removeClass("hidden"),button.find(SELECTORS_LOADING_ICON_CONTAINER).addClass("hidden")},showLoadMoreMessagesButton=function(root){root.find(SELECTORS_LOAD_MORE_MESSAGES).removeClass("hidden")},findContact=function(root,userId){return root.find('[data-contact-user-id="'+userId+'"]')},highlightSearch=function(content,searchText){if(!content)return"";var regex=new RegExp("("+searchText+")","gi");return content.replace(regex,'<span class="matchtext">$1</span>')},renderMessages=function(root,messages){var container=root.find(SELECTORS_MESSAGES_CONTAINER),frompanel=root.attr("data-in-panel"),list=container.find(SELECTORS_LIST);return Templates.render(TEMPLATES_MESSAGES_LIST,{messages:messages,frompanel:frompanel}).then((function(html){return list.append(html),html}))},loadMoreUsers=function(root,loggedInUserId,text,limit,offset){var loadedAll=!1;return function(root){var button=root.find(SELECTORS_LOAD_MORE_USERS);button.prop("disabled",!0),button.find(SELECTORS_BUTTON_TEXT).addClass("hidden"),button.find(SELECTORS_LOADING_ICON_CONTAINER).removeClass("hidden")}(root),Repository.searchUsers(loggedInUserId,text,limit+1,offset).then((function(results){var contacts=results.contacts,noncontacts=results.noncontacts;return contacts.length<=limit&&noncontacts.length<=limit?(loadedAll=!0,{contacts:contacts,noncontacts:noncontacts}):{contacts:contacts.slice(0,limit),noncontacts:noncontacts.slice(0,limit)}})).then((function(results){var contactsCount=results.contacts.length,nonContactsCount=results.noncontacts.length;return contactsCount&&results.contacts.forEach((function(contact){contact.highlight=highlightSearch(contact.fullname,text)})),nonContactsCount&&results.noncontacts.forEach((function(contact){contact.highlight=highlightSearch(contact.fullname,text)})),$.when(!contactsCount||function(root,contacts){var container=getContactsContainer(root),frompanel=root.attr("data-in-panel"),list=container.find(SELECTORS_LIST);return Templates.render(TEMPLATES_CONTACTS_LIST,{contacts:contacts,frompanel:frompanel}).then((function(html){return list.append(html),html}))}(root,results.contacts),!nonContactsCount||function(root,nonContacts){var container=getNonContactsContainer(root),frompanel=root.attr("data-in-panel"),list=container.find(SELECTORS_LIST);return Templates.render(TEMPLATES_NON_CONTACTS_LIST,{noncontacts:nonContacts,frompanel:frompanel}).then((function(html){return list.append(html),html}))}(root,results.noncontacts)).then((function(){return{contactsCount:contactsCount,nonContactsCount:nonContactsCount}}))})).then((function(counts){return hideUsersLoadingIcon(root),loadedAll&&function(root){root.find(SELECTORS_LOAD_MORE_USERS).addClass("hidden")}(root),counts})).catch((function(error){throw hideUsersLoadingIcon(root),error}))},loadMoreMessages=function(root,loggedInUserId,text,limit,offset){var loadedAll=!1;return function(root){var button=root.find(SELECTORS_LOAD_MORE_MESSAGES);button.prop("disabled",!0),button.find(SELECTORS_BUTTON_TEXT).addClass("hidden"),button.find(SELECTORS_LOADING_ICON_CONTAINER).removeClass("hidden")}(root),Repository.searchMessages(loggedInUserId,text,limit+1,offset).then((function(results){var messages=results.contacts;return messages.length<=limit?(loadedAll=!0,messages):messages.slice(0,limit)})).then((function(messages){return messages.length?(messages.forEach((function(message){message.lastmessage=highlightSearch(message.lastmessage,text)})),renderMessages(root,messages).then((function(){return messages.length}))):messages.length})).then((function(count){return hideMessagesLoadingIcon(root),loadedAll&&function(root){root.find(SELECTORS_LOAD_MORE_MESSAGES).addClass("hidden")}(root),count})).catch((function(error){throw hideMessagesLoadingIcon(root),error}))},search=function(header,body,searchText,usersLimit,usersOffset,messagesLimit,messagesOffset){var loggedInUserId=getLoggedInUserId(body);return startLoading(header,body),clearAllSearchResults(body),$.when(loadMoreUsers(body,loggedInUserId,searchText,usersLimit,usersOffset),loadMoreMessages(body,loggedInUserId,searchText,messagesLimit,messagesOffset)).then((function(userCounts,messagesCount){var contactsCount=userCounts.contactsCount,nonContactsCount=userCounts.nonContactsCount;stopLoading(header,body),contactsCount||nonContactsCount||messagesCount?(contactsCount||nonContactsCount?(contactsCount||function(body){getSearchResultsContainer(body).find(SELECTORS_CONTACTS_CONTAINER).addClass("hidden")}(body),nonContactsCount||function(body){getSearchResultsContainer(body).find(SELECTORS_NON_CONTACTS_CONTAINER).addClass("hidden")}(body)):function(body){getSearchResultsContainer(body).find(SELECTORS_ALL_CONTACTS_CONTAINER).addClass("hidden")}(body),messagesCount||function(body){getSearchResultsContainer(body).find(SELECTORS_MESSAGES_CONTAINER).addClass("hidden")}(body)):function(body){var container=getSearchResultsContainer(body);container.find(SELECTORS_ALL_CONTACTS_CONTAINER).addClass("hidden"),container.find(SELECTORS_MESSAGES_CONTAINER).addClass("hidden"),container.find(SELECTORS_NO_RESULTS_CONTAINTER).removeClass("hidden")}(body)}))},registerEventListeners=function(header,body){var loggedInUserId=getLoggedInUserId(body),searchInput=getSearchInput(header),searchText="",messagesOffset=0,usersOffset=0,searchEventHandler=function(e,data){""!==(searchText=searchInput.val().trim())&&search(header,body,searchText,3,usersOffset=0,50,messagesOffset=0).then((function(){searchInput.focus(),usersOffset+=3,messagesOffset+=50})).catch(Notification.exception),data.originalEvent.preventDefault()};CustomEvents.define(searchInput,[CustomEvents.events.enter]),CustomEvents.define(header,[CustomEvents.events.activate]),CustomEvents.define(body,[CustomEvents.events.activate]),searchInput.on(CustomEvents.events.enter,searchEventHandler),header.on(CustomEvents.events.activate,SELECTORS_SEARCH_ACTION,searchEventHandler),body.on(CustomEvents.events.activate,SELECTORS_LOAD_MORE_MESSAGES,(function(e,data){""!==searchText&&loadMoreMessages(body,loggedInUserId,searchText,50,messagesOffset).then((function(){messagesOffset+=50})).catch(Notification.exception),data.originalEvent.preventDefault()})),body.on(CustomEvents.events.activate,SELECTORS_LOAD_MORE_USERS,(function(e,data){""!==searchText&&loadMoreUsers(body,loggedInUserId,searchText,50,usersOffset).then((function(){usersOffset+=50})).catch(Notification.exception),data.originalEvent.preventDefault()})),header.on(CustomEvents.events.activate,SELECTORS_CANCEL_SEARCH_BUTTON,(function(){!function(header){getSearchInput(header).val("")}(header),function(body){getEmptyMessageContainer(body).removeClass("hidden")}(body),showSearchIcon(header),hideSearchResults(body),hideLoadingIcon(header),hideLoadingPlaceholder(body),usersOffset=0,messagesOffset=0})),PubSub.subscribe(Events.CONTACT_ADDED,(function(userId){!function(root,contact){var nonContactsContainer=getNonContactsContainer(root),nonContact=findContact(nonContactsContainer,contact.userid);if(nonContact.length){nonContact.remove();var contactsContainer=getContactsContainer(root);contactsContainer.removeClass("hidden"),contactsContainer.find(SELECTORS_LIST).append(nonContact)}nonContactsContainer.find(SELECTORS_LIST).children().length||nonContactsContainer.addClass("hidden")}(body,userId)})),PubSub.subscribe(Events.CONTACT_REMOVED,(function(userId){!function(root,userId){var contactsContainer=getContactsContainer(root),contact=findContact(contactsContainer,userId);if(contact.length){contact.remove();var nonContactsContainer=getNonContactsContainer(root);nonContactsContainer.removeClass("hidden"),nonContactsContainer.find(SELECTORS_LIST).append(contact)}contactsContainer.find(SELECTORS_LIST).children().length||contactsContainer.addClass("hidden")}(body,userId)})),PubSub.subscribe(Events.CONTACT_BLOCKED,(function(userId){!function(root,userId){var contact=findContact(root,userId);contact.length&&contact.find(SELECTORS_BLOCK_ICON_CONTAINER).removeClass("hidden")}(body,userId)})),PubSub.subscribe(Events.CONTACT_UNBLOCKED,(function(userId){!function(root,userId){var contact=findContact(root,userId);contact.length&&contact.find(SELECTORS_BLOCK_ICON_CONTAINER).addClass("hidden")}(body,userId)}))};return{show:function(namespace,header,body){return body.attr("data-init")||(registerEventListeners(header,body),body.attr("data-init",!0)),getSearchInput(header).focus(),$.Deferred().resolve().promise()},description:function(namespace,header){if("object"!==_typeof(header))return Str.get_string("messagedrawerviewsearch","core_message");var searchText=getSearchInput(header).val().trim();return Str.get_string("messagedrawerviewsearch","core_message",searchText)}}}));

//# sourceMappingURL=message_drawer_view_search.min.js.map