/**
 * Standard Ajax wrapper for Moodle. It calls the central Ajax script,
 * which can call any existing webservice using the current session.
 * In addition, it can batch multiple requests and return multiple responses.
 *
 * @module     mod_lti/tool_configure_controller
 * @copyright  2015 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since      3.1
 */
define("mod_lti/tool_configure_controller",["jquery","core/ajax","core/notification","core/templates","mod_lti/events","mod_lti/keys","mod_lti/tool_type","mod_lti/tool_proxy","core/str"],(function($,ajax,notification,templates,ltiEvents,KEYS,toolType,toolProxy,str){var SELECTORS_EXTERNAL_REGISTRATION_CONTAINER="#external-registration-container",SELECTORS_EXTERNAL_REGISTRATION_PAGE_CONTAINER="#external-registration-page-container",SELECTORS_EXTERNAL_REGISTRATION_TEMPLATE_CONTAINER="#external-registration-template-container",SELECTORS_CARTRIDGE_REGISTRATION_CONTAINER="#cartridge-registration-container",SELECTORS_CARTRIDGE_REGISTRATION_FORM="#cartridge-registration-form",SELECTORS_TOOL_LIST_CONTAINER="#tool-list-container",SELECTORS_TOOL_CREATE_BUTTON="#tool-create-button",SELECTORS_TOOL_CREATE_LTILEGACY_BUTTON="#tool-createltilegacy-button",SELECTORS_REGISTRATION_CHOICE_CONTAINER="#registration-choice-container",SELECTORS_TOOL_URL="#tool-url",getToolListContainer=function(){return $(SELECTORS_TOOL_LIST_CONTAINER)},getExternalRegistrationContainer=function(){return $(SELECTORS_EXTERNAL_REGISTRATION_CONTAINER)},getCartridgeRegistrationContainer=function(){return $(SELECTORS_CARTRIDGE_REGISTRATION_CONTAINER)},getRegistrationChoiceContainer=function(){return $(SELECTORS_REGISTRATION_CHOICE_CONTAINER)},closeLTIAdvRegistration=function(e){e.data&&"org.imsglobal.lti.close"===e.data.subject&&($(SELECTORS_EXTERNAL_REGISTRATION_TEMPLATE_CONTAINER).empty(),hideExternalRegistration(),showRegistrationChoices(),showToolList(),showRegistrationChoices(),reloadToolList())},getToolURL=function(){return $(SELECTORS_TOOL_URL).val()},hideExternalRegistration=function(){getExternalRegistrationContainer().addClass("hidden")},hideCartridgeRegistration=function(){getCartridgeRegistrationContainer().addClass("hidden")},hideRegistrationChoices=function(){getRegistrationChoiceContainer().addClass("hidden")},showExternalRegistration=function(){hideCartridgeRegistration(),hideRegistrationChoices(),getExternalRegistrationContainer().removeClass("hidden"),screenReaderAnnounce(getExternalRegistrationContainer())},showRegistrationChoices=function(){hideExternalRegistration(),hideCartridgeRegistration(),getRegistrationChoiceContainer().removeClass("hidden"),screenReaderAnnounce(getRegistrationChoiceContainer())},screenReaderAnnounce=function(element){element.children().detach().appendTo(element)},hideToolList=function(){getToolListContainer().addClass("hidden")},showToolList=function(){getToolListContainer().removeClass("hidden")},startLoading=function(element){element.addClass("loading")},stopLoading=function(element){element.removeClass("loading")},reloadToolList=function(){var promise=$.Deferred(),container=getToolListContainer();startLoading(container),$.when(toolType.query(),toolProxy.query({orphanedonly:!0})).done((function(types,proxies){templates.render("mod_lti/tool_list",{tools:types,proxies:proxies}).done((function(html,js){container.empty(),container.append(html),templates.runTemplateJS(js),promise.resolve()})).fail(promise.reject)})).fail(promise.reject),promise.fail(notification.exception).always((function(){stopLoading(container)}))},addLTIAdvTool=function(){var url=getToolURL().trim();url&&($(SELECTORS_TOOL_URL).val(""),hideToolList(),function(url){$(SELECTORS_EXTERNAL_REGISTRATION_PAGE_CONTAINER).removeClass("hidden"),$(SELECTORS_EXTERNAL_REGISTRATION_TEMPLATE_CONTAINER).append($("<iframe src='startltiadvregistration.php?url="+encodeURIComponent(url)+"'></iframe>")),showExternalRegistration(),window.addEventListener("message",closeLTIAdvRegistration,!1)}(url))},registerEventListeners=function(){$(document).on(ltiEvents.NEW_TOOL_TYPE,(function(){reloadToolList()})),$(document).on(ltiEvents.START_EXTERNAL_REGISTRATION,(function(){showExternalRegistration(),$(SELECTORS_TOOL_URL).val(""),hideToolList()})),$(document).on(ltiEvents.STOP_EXTERNAL_REGISTRATION,(function(){showToolList(),showRegistrationChoices()})),$(document).on(ltiEvents.START_CARTRIDGE_REGISTRATION,(function(event,url){!function(url){hideExternalRegistration(),hideRegistrationChoices();var container=getCartridgeRegistrationContainer();container.find("input").val(""),container.removeClass("hidden"),container.find(SELECTORS_CARTRIDGE_REGISTRATION_FORM).attr("data-cartridge-url",url),screenReaderAnnounce(container)}(url)})),$(document).on(ltiEvents.STOP_CARTRIDGE_REGISTRATION,(function(){getCartridgeRegistrationContainer().find(SELECTORS_CARTRIDGE_REGISTRATION_FORM).removeAttr("data-cartridge-url"),showRegistrationChoices()})),$(document).on(ltiEvents.REGISTRATION_FEEDBACK,(function(event,data){!function(data){var type=data.error?"error":"success";notification.addNotification({message:data.message,type:type})}(data)})),$(SELECTORS_TOOL_CREATE_LTILEGACY_BUTTON).click((function(e){e.preventDefault(),function(){var url=getToolURL().trim();if(""===url)return $.Deferred().resolve();var toolButton=$(SELECTORS_TOOL_CREATE_LTILEGACY_BUTTON);startLoading(toolButton);var promise=toolType.isCartridge(url);promise.always((function(){stopLoading(toolButton)})),promise.done((function(result){result.iscartridge?($(SELECTORS_TOOL_URL).val(""),$(document).trigger(ltiEvents.START_CARTRIDGE_REGISTRATION,url)):$(document).trigger(ltiEvents.START_EXTERNAL_REGISTRATION,{url:url})})),promise.fail((function(){str.get_string("errorbadurl","mod_lti").done((function(s){$(document).trigger(ltiEvents.REGISTRATION_FEEDBACK,{message:s,error:!0})})).fail(notification.exception)}))}()})),$(SELECTORS_TOOL_CREATE_BUTTON).click((function(e){e.preventDefault(),addLTIAdvTool()}))};return{init:function(){registerEventListeners(),reloadToolList()}}}));

//# sourceMappingURL=tool_configure_controller.min.js.map